let myposition = 0;

document.addEventListener('DOMContentLoaded', function() {
  document.getElementById('optionsLabel').innerHTML = lang[langu]['options'];
  document.getElementById('optionsOpen').addEventListener('click', openOptions);
});

function openOptions() {
  chrome.tabs.create({ 'url': "options.html" });
}

document.addEventListener("keyup", (event) => {
  key_up(event);
});

chrome.runtime.connect({ name: 'sidepanel' });

chrome.runtime.onMessage.addListener(({ name, data }) => {

  if (name === 'botonitos') {

    myposition = data.myposition;
    setButtons(data.value);

  } else if (name === 'state') {

    var btn = document.getElementById('boton_' + data.nro);
    if (btn !== null) {
      if (data.removeclass != '') {
        btn.classList.remove(data.removeclass);
      }
      if (data.addclass != '') {
        btn.classList.add(data.addclass);
      }
    }

  } else if (name === 'paused') {

    var elm = document.getElementById('paused_' + data.nro);
    if (data.paused == 1) {
      elm.classList.remove('invisible');
      elm.title = data.reason;
    } else {
      elm.classList.add('invisible');
      elm.title = '';
    }

  } else if (name === 'mwi') {

    var elm = document.getElementById('mwi_' + data.nro);
    if (data.texto == '1') {
      elm.classList.remove('transparent');
      elm.classList.remove('invisible');
    } else if (data.texto == '2') {
      elm.classList.remove('invisible');
      elm.classList.add('transparent');
    } else {
      elm.classList.add('invisible');
      elm.classList.remove('transparent');
    }

  }
  // We don't need to return anything. Returning true causes the service worker to expect an asynchronous response.
  //return true;

});

function setButtons(botones) {

  $('#listabotones').empty();

  if (botones[myposition] !== undefined) {
    if (botones[myposition]['EXTENSION'] !== undefined) {
      drawButton(myposition, botones[myposition], 'strong');
    }
  }

  for (var s = 0; s < botones.length; s++) {
    if (botones[s] !== undefined && botones[s] !== null) {
      if (botones[s]['TYPE'] == 'extension') {
        if (botones[s]['EXTENSION'] !== undefined) {
          if (s != myposition) {
            drawButton(s, botones[s], '');
          }
        }
      }
    }
  }
}

function drawButton(id, botState, bold) {

  // Commented because it was causing 'errors' in the extension
  // console.warn("draw button " + id + " " + botState['EXTENSION']);
  // console.warn(botState);

  var botonstate = 'free';
  var pausedstate = 'invisible';
  var qualy = "";
  var label = botState['EXTENSION'] + ' ' + Base64._utf8_decode(botState['LABEL']);

  if (botState['PAUSED'] == 1) {
    pausedstate = 'visible';
  }

  if (botState['STATE'] == 'busy') {
    botonstate = 'busy';
  }
  if (botState['MWISTATE'] == '2') {
    mwistate = 'transparent';
  } else if (botState['MWISTATE'] == '1') {
    mwistate = 'visible';
  } else {
    mwistate = 'invisible';
  }
  if (botState['QUALIFY']) {
    if (botState['QUALIFY'] == 'notok') {
      qualy = 'transparent';
    }
  }

  var elm = jQuery('<div/>', { 'id': 'boton_' + id, 'class': 'boton ' + ' ' + botonstate + ' ' + qualy, 'data-extension': botState['EXTENSION'] }).appendTo('#listabotones');
  var lin = jQuery('<div/>', { 'class': 'linewrapper' }).appendTo(elm);
  jQuery('<div/>', { 'id': 'label_' + id, 'class': 'label ' + bold, 'text': label }).appendTo(lin);
  jQuery('<div/>', { 'id': 'mwi_' + id, 'class': 'mwi ' + mwistate }).appendTo(lin);
  jQuery('<div/>', { 'id': 'paused_' + id, 'class': 'pauseicon ' + pausedstate, 'title': botState['PAUSEREASON'] }).appendTo(lin);
  jQuery('#boton_' + id).click(function() {
    extension = $(this).data('extension');
    chrome.runtime.sendMessage({ 'makeCall': true, 'phoneNumber': extension }, function(response) { });
  });
}

function key_up(event) {
  if (event.keyCode == 27) {
    $('#filtertext').val('');
    filter_list();
  } else {
    if (event.target.id == 'filtertext') {
      filter_list();
    }
  }
}

function filter_list() {
  var mostrar = [];
  var text_filter = $('#filtertext').val();
  text_filter = text_filter.toLowerCase();
  $('#listabotones').find('.label').each(function(i) {
    var btnnro = this.id.substring(5, this.id.length);
    if (!$('#boton' + btnnro).hasClass('nodisplay')) {
      $('#boton' + btnnro).show();
      if (text_filter != "") {
        contiene = $('#boton' + btnnro).text().toLowerCase();
        var result = contiene.indexOf(text_filter);
        if (result == -1) {
          if (mostrar[btnnro] === undefined) {
            $('#boton' + btnnro).hide();
          }
        }
      }
    }
  });
}
