import * as module from './md5.min.js';
import Base64 from './base64_module.js';
import BadgeTextAnimator from './animator.js';
import { lang } from './lang_module.js';

const TEN_SECONDS_MS = 10 * 1000;
let webSocket = null;
let lastkey = "";
let botonitos = [];
let chanvars = [];
let myposition = 0;
let myextension = '';
let sidepanel_live = 0;
let alreadynotified = 0;
let ctxid = 0;

let wshost = '';
let wsport = '';
let exten = '';
let context = '';
let secret = '';
let popup = '';
let prefix = '';
let clicktoopen = '';
let subversion = 0;
let langu = 'en'
let poplink = '';
let popbody = '';
let prevent_popups_from = '';

chrome.sidePanel
  .setPanelBehavior({ openPanelOnActionClick: true })
  .catch((error) => console.error(error));

// Handle click on desktop notification
self.addEventListener('notificationclick', function(event) {
  if (clicktoopen == 1 && poplink != '') {
    chrome.tabs.create({ url: poplink, active: false });
  }
  event.notification.close()
});

// Runs when the extension is installed or updated, sets up the context menu
chrome.runtime.onInstalled.addListener(function() {

  chrome.storage.local.get(['lang']).then((value) => {

    if (value.lang === undefined) { value.lang = 'en'; } langu = value.lang;
    var dialtext = translate('&dial');

    ctxid = chrome.contextMenus.create({
      title: dialtext + ' %s',
      contexts: ['selection'],
      id: 'selection'
    });

  });
});

chrome.contextMenus.onClicked.addListener((item, tab) => {
  dial(item.selectionText);
});

chrome.storage.local.get(['wshost', 'wsport', 'exten', 'context', 'pass', 'prefix', 'popup', 'clicktoopen', 'lang']).then((value) => {
  if (value.wshost === undefined) { value.wshost = '192.168.10.1'; } wshost = value.wshost;
  if (value.wsport === undefined) { value.wsport = '4445'; } wsport = value.wsport;
  if (value.exten === undefined) { value.exten = ''; } exten = value.exten;
  if (value.context === undefined) { value.context = ''; } context = value.context;
  if (value.pass === undefined) { value.pass = ''; } secret = value.pass;
  if (value.prefix === undefined) { value.prefix = ''; } prefix = stripNonNumeric(value.prefix);
  if (value.popup === undefined) { value.popup = 0; } popup = value.popup;
  if (value.clicktoopen === undefined) { value.clicktoopen = 0; } clicktoopen = value.clicktoopen;
  if (value.lang === undefined) { value.lang = 'en'; } langu = value.lang;

  if (!webSocket) {
    connect();
    keepAlive();
  }
});

chrome.runtime.onConnect.addListener(function(port) {
  if (port.name === 'sidepanel') {
    port.onDisconnect.addListener(async () => {
      debug('sidepanel closed.');
      sidepanel_live = 0;
    });

    sidepanel_live = 1;
    debug("sidepanel connected");

    console.log("send messages from service worker to sidepanel on sidepanel open");

    chrome.runtime.sendMessage({
      name: 'botonitos',
      data: { value: botonitos, myposition: myposition }
    });

  }
});

chrome.runtime.onMessage.addListener(
  function(request, sender, sendResponse) {
    if (request.makeCall === true) {
      console.log("marcar a " + request.phoneNumber);
      dial(request.phoneNumber);
    } else if (request.saveoptions === true) {
      chrome.storage.local.get(['lang']).then((value) => {
        if (value.lang === undefined) { value.lang = 'en'; } langu = value.lang;
        var dialtext = translate('&dial') + ' %s';
        chrome.contextMenus.update(ctxid, { title: dialtext });
      });
    } else if (request.reconnect === true) {
      chrome.storage.local.get(['wshost', 'wsport', 'exten', 'context', 'pass', 'prefix', 'popup', 'clicktoopen', 'lang']).then((value) => {
        if (value.wshost === undefined) { value.wshost = '192.168.10.1'; } wshost = value.wshost;
        if (value.wsport === undefined) { value.wsport = '4445'; } wsport = value.wsport;
        if (value.exten === undefined) { value.exten = ''; } exten = value.exten;
        if (value.context === undefined) { value.context = ''; } context = value.context;
        if (value.pass === undefined) { value.pass = ''; } secret = value.pass;
        if (value.prefix === undefined) { value.prefix = ''; } prefix = stripNonNumeric(value.prefix);
        if (value.popup === undefined) { value.popup = 0; } popup = value.popup;
        if (value.clicktoopen === undefined) { value.clicktoopen = 0; } clicktoopen = value.clicktoopen;
        if (value.lang === undefined) { value.lang = 'en'; } langu = value.lang;
        if (webSocket) {
          disconnect()
        } else {
          connect();
          keepAlive();
        }
      });
    }
    sendResponse({ damn: true });
  }
);

var animator = new BadgeTextAnimator({
  text: 'Unable to connect to server', // text to be scrolled (or animated)
  interval: 200, // the "speed" of the scrolling
  repeat: true, // repeat the animation or not
  size: 6 // size of the badge
});

function commandCenter() {

  function key(nro, texto, slot) {
    //chrome.browserAction.setIcon({ path: "images/telephone19.png"});
    //animator.options.text='ok';
    //animator.stop();
    lastkey = texto;
  }

  function version(nro, texto, slot) {

    var clave = secret + lastkey;
    var hash = md5(clave);

    var partes = texto.split('!');
    var pertes = partes[0].split('.');
    subversion = pertes[1];
    subversion = subversion.replace(/\D/g, '');

    var comando = "<msg data=\"2|auth|" + exten + "|" + hash + "\" />";
    send(comando);


  }

  function incorrect(nro, texto, slot) {
    debug("Auth incorrect");
    chrome.action.setIcon({ path: "images/telephone19red.png" });
    if (animator.intervalId === null) {
      animator.options.text = 'Invalid Credentials';
      animator.index = 0;
      animator.animate();
    }
  }

  function clidnum(nro, texto, slot) {
    if (myposition == nro) {
      if (chanvars[nro] === undefined) {
        chanvars[nro] = {};
      }
      chanvars[nro]['CLIDNUM'] = texto;

    }
  }

  function clidname(nro, texto, slot) {
    if (myposition == nro) {
      if (chanvars[nro] === undefined) {
        chanvars[nro] = {};
      }
      chanvars[nro]['CLIDNAME'] = texto;

    }
  }

  function fromqueue(nro, texto, slot) {
    if (myposition == nro) {
      if (chanvars[nro] === undefined) {
        chanvars[nro] = {};
      }
      chanvars[nro]['FROMQUEUE'] = texto;

    }
  }

  function setvar(nro, texto, slot) {
    if (myposition == nro) {
      var textdecode = Base64.decode(texto);
      if (textdecode.indexOf("=") >= 1) {
        if (chanvars[nro] === undefined) {
          chanvars[nro] = {};
        }
        var partes = textdecode.split("=");
        chanvars[nro][partes[0]] = partes[1];

      }
    }
  }

  function notifyconnect(nro, texto, slot) {
    if (alreadynotified == 0) {
      actualnotify(nro, 'connected_call');
      if (myposition == nro) {
        alreadynotified = 1;
      }
    }
  }

  function notifyringing(nro, texto, slot) {
    actualnotify(nro, 'incoming_call');
  }

  function zbuttons(nro, texto, slot) {

    botonitos = [];
    chanvars = [];

    var lineas = '';

    if (subversion >= 29) {
      lineas = Base64.decode(texto).split("\n");
    } else {
      chrome.action.setIcon({ path: "images/telephone19red.png" });
      animator.stop();
      animator.options.text = 'Upgrade FOP2 server';
      animator.index = 0;
      animator.animate();
      return;
    }

    for (var x = 0; x < lineas.length; x++) {
      var pepe = lineas[x].split("!");
      var nritoPartes = pepe[0].split("@");
      var nrito = nritoPartes[0];
      for (var s = 0; s < pepe.length; s++) {
        var partos = pepe[s].split("=", 2);

        if (botonitos[nrito] == undefined) {
          botonitos[nrito] = {};
        }
        botonitos[nrito][partos[0]] = partos[1];

        if (partos[0] !== "") {
          if (partos[0] == "EXTENSION") {
            if (partos[1] == exten) {
              myposition = nrito;
              myextension = exten;
              debug('My position is ' + myposition);
            }
          }
        }
      }
    }

    if (sidepanel_live == 1) {

      console.log("send messages from service worker to sidepanel on zbuttons");
      chrome.runtime.sendMessage({
        name: 'botonitos',
        data: { value: botonitos, myposition: myposition }
      }).catch(() => {
        console.log("Side panel not responding. It was probably just closed.")
      });

    }

    askFirstState();
  }

  function qualify(nro, texto, slot) {

    var estadosacar = '';
    var estadofinal = '';

    botonitos[nro]['QUALIFY'] = texto;

    if (texto == 'ok') {
      estadosacar = 'transparent';
      estadofinal = '';
    } else {
      estadosacar = '';
      estadofinal = 'transparent';
    }

    if (sidepanel_live == 1) {
      console.log("send messages from service worker to sidepanel on qualiry");
      chrome.runtime.sendMessage({
        name: 'state',
        data: { addclass: estadofinal, removeclass: estadosacar, nro: nro }
      }).catch(() => {
        console.log("Side panel not responding. It was probably just closed.")
      });
    }

  }

  function state(nro, texto, slot) {
    var estadofinal = '';
    var estadosacar = '';
    var estados = texto.split("+");
    if (estados.includes('RINGING') || estados.includes('UP')) {
      botonitos[nro]['STATE'] = "busy"
      estadosacar = 'free';
      estadofinal = 'busy';
    } else {
      botonitos[nro]['STATE'] = "free"
      estadosacar = 'busy';
      estadofinal = 'free';

      // Borro variables de canal en state down
      if (myposition == nro) {
        alreadynotified = 0;
        if (chanvars[nro] !== undefined) {
          for (var j in chanvars[nro]) {
            delete chanvars[nro][j];
          }
        }
      }
    }
    if (sidepanel_live == 1) {
      console.log("send messages from service worker to sidepanel on state");
      chrome.runtime.sendMessage({
        name: 'state',
        data: { addclass: estadofinal, removeclass: estadosacar, nro: nro }
      }).catch(() => {
        console.log("Side panel not responding. It was probably just closed.")
      });
    }
  }

  function voicemail(nro, texto, slot) {
    botonitos[nro]['MWISTATE'] = texto;
    if (sidepanel_live == 1) {
      console.log("send messages from service worker to sidepanel on voicemail");
      chrome.runtime.sendMessage({
        name: 'mwi',
        data: { nro: nro, texto: texto }
      }).catch(() => {
        console.log("Side panel not responding. It was probably just closed.")
      });
    }
  }

  function presence(nro, texto, slot) {
    let texto_decoded = Base64.decode(texto);
    let paused = 0;
    if (texto_decoded != '') {
      paused = 1;
      botonitos[nro]['PAUSED'] = 1;
      botonitos[nro]['PAUSEREASON'] = texto_decoded;
    } else {
      botonitos[nro]['PAUSED'] = 0;
      botonitos[nro]['PAUSEREASON'] = '';
    }
    if (sidepanel_live == 1) {
      console.log("send messages from service worker to sidepanel on presence");
      chrome.runtime.sendMessage({
        name: 'paused',
        data: { paused: paused, nro: nro, reason: texto_decoded }
      }).catch(() => {
        console.log("Side panel not responding. It was probably just closed.")
      });
    }
  }

  function actualnotify(nro, titulo) {
    if (myposition == nro) {
      chrome.storage.local.get(['poplink', 'popbody']).then((value) => {

        poplink = value.poplink;
        popbody = value.popbody;

        if (poplink != '') {
          // only open popup link if defined
          var patt1 = /#\{[^\}]*\}/g;
          var coinciden = poplink.match(patt1);
          if (coinciden !== null) {
            for (var a = 0; a < coinciden.length; a++) {
              var vari = coinciden[a].substr(2, coinciden[a].length - 3);
              var valor = '';
              if (vari == 'CLIDNUM' || vari == 'CLIDNAME') {
                valor = Base64.decode(chanvars[nro][vari]);
                if (vari == 'CLIDNUM') {
                  if (prevent_popups_from == valor || myextension == valor) {
                    prevent_popups_from = '';
                    console.warn("no popup as we have dialed it");
                    return;
                  }
                }
              } else {
                valor = chanvars[nro][vari];
              }
              poplink = replace(poplink, coinciden[a], valor);
            }
          }

          // call javascript function instead of open new tab
          if (poplink.indexOf('javascript:') == 0) {

            poplink = poplink.substr(11);
            var partes = poplink.split('?');
            var callfunction = partes[0];

            var queryDict = {}
            partes[1].split("&").forEach(function(item) { queryDict[item.split("=")[0]] = item.split("=")[1] })

            // call function
            chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
              console.log(tabs);
              chrome.tabs.sendMessage(tabs[0].id, { message: "popup", call: callfunction, params: queryDict }, function(response) {
                // console.log(response);
              }).catch(() => {
                console.log("No response from tabs for popup received.")
              });
            });

          } else {
            // create new tab
            if (clicktoopen != 1) {
              chrome.tabs.create({ url: poplink, active: false });
            }
          }
        }

        if (popup == 1) {

          // call notifications enabled
          var tituloText = translate('&' + titulo);
          var notiText = "";
          if (chanvars[nro] !== undefined) {
            for (var vari in chanvars[nro]) {
              if (vari == 'CLIDNUM' || vari == 'CLIDNAME') {
                value = Base64.decode(chanvars[nro][vari]);
                // atob does not support utf8
                // value = window.atob(chanvars[nro][vari]);
              } else {
                if (/^[0-9]*$/.test(chanvars[nro][vari])) {
                  // let numbers pass undecoded
                  value = chanvars[nro][vari];
                } else {
                  try {
                    value = windows.atob(chanvars[nro][vari]);
                  } catch (e) {
                    value = chanvars[nro][vari];
                  }
                }
              }
              notiText += value + "\n";
            }
          }
          var image = chrome.runtime.getURL('images/telephone48.png');
          var notitag = chanvars[nro]['CLIDNUM']; // We want only one notification per callerid
          if (notitag === undefined) { notitag = 'fop2'; }
          if (popbody == '') {

            registration.showNotification(tituloText, {
              body: notiText,
              data: '1234uuid',
              icon: image,
              tag: notitag,
              actions: [
                { action: 'Open', title: 'Open' },
                { action: 'Close', title: 'Close' }
              ]
            });

          } else {
            // do ajax call to get popup content and show only after ajax completes
            // only open popup body if defined
            var patt1 = /#\{[^\}]*\}/g;
            var coinciden = popbody.match(patt1);
            if (coinciden !== null) {
              for (var a = 0; a < coinciden.length; a++) {
                var vari = coinciden[a].substr(2, coinciden[a].length - 3);
                var valor = '';
                if (vari == 'CLIDNUM' || vari == 'CLIDNAME') {
                  valor = Base64.decode(chanvars[nro][vari]);
                } else {
                  valor = chanvars[nro][vari];
                }
                popbody = replace(popbody, coinciden[a], valor);
              }
            }
            fetch(popbody).then(function(response) {
              return response.text().then(function(notiText) {
                registration.showNotification(tituloText, {
                  body: notiText,
                  data: '1234uuid',
                  icon: image,
                  tag: notitag,
                  actions: [
                    { action: 'Open', title: 'Open' },
                    { action: 'Close', title: 'Close' }
                  ]
                });
              });
            });
          }
        }

      });
    }
  }

  this.voicemail = voicemail;
  this.presence = presence;
  this.qualify = qualify;
  this.state = state;
  this.zbuttons = zbuttons;
  this.key = key;
  this.incorrect = incorrect;
  this.version = version;
  this.clidnum = clidnum;
  this.clidname = clidname;
  this.fromqueue = fromqueue;
  this.setvar = setvar;
  this.notifyringing = notifyringing;
  this.notifyconnect = notifyconnect;

}

var execute = new commandCenter();

function replace(string, text, by) {
  // Replaces text with by in string
  var strLength = string.length, txtLength = text.length;
  if ((strLength === 0) || (txtLength === 0)) { return string; }

  var i = string.indexOf(text);
  if ((!i) && (text != string.substring(0, txtLength))) { return string; }
  if (i == -1) { return string; }

  var newstr = string.substring(0, i) + by;

  if (i + txtLength < strLength) {
    newstr += replace(string.substring(i + txtLength, strLength), text, by);
  }

  return newstr;
};

function askFirstState() {
  var clave = secret + lastkey;
  var hash = md5(clave);
  var comando = "<msg data=\"1|initState||" + hash + "\" />";
  send(comando);
};

function logout() {
  var clave = secret + lastkey;
  var hash = md5(clave);
  var comando = "<msg data=\"1|close|" + exten + "|" + hash + "\" />";
  send(comando);
}

chrome.action.onClicked.addListener(async () => {
  if (!webSocket) {
    connect();
    keepAlive();
  } else {
    console.log(webSocket);
  }
});

/*
chrome.action.onClicked.addListener(async () => {
  if (webSocket) {
    console.log('try disconnect');
    disconnect();
  } else {
    console.log('try connect');
    connect();
    keepAlive();
  }
});
*/

function connect() {
  webSocket = new WebSocket('ws://' + wshost + ':' + wsport);

  webSocket.onopen = (event) => {
    chrome.action.setIcon({ path: 'images/telephone19green.png' });
    animator.stop();
    connectContext();
    console.log('websocket connection opened');
  };

  webSocket.onmessage = (event) => {
    //console.log(event.data);
    var data = JSON.parse(event.data);
    appendData(data);
  };

  webSocket.onclose = (event) => {
    chrome.action.setIcon({ path: 'images/telephone19.png' });
    console.log('websocket connection closed');
    console.log(event);
    webSocket = null;
    animator.stop();
    animator.options.text = 'Unable to connect to server';
    animator.index = 0;
    animator.animate();
  };
}

function disconnect() {
  if (webSocket) {
    logout();
    webSocket.close();
  }
}

function keepAlive() {
  const keepAliveIntervalId = setInterval(
    () => {
      if (webSocket && webSocket.readyState === webSocket.OPEN) {
        webSocket.send('ping');
      } else {
        if (!webSocket) {
          connect();
        }
      }
    },
    // It's important to pick an interval that's shorter than 30s, to
    // avoid that the service worker becomes inactive.
    TEN_SECONDS_MS
  );
}

function connectContext() {
  if (context !== "") {
    var context_upper = context.toUpperCase();
    send("<msg data=\"" + context_upper + "|contexto|1|\" />");
  } else {
    send("<msg data=\"GENERAL|contexto|1|\" />");
  }
};

function send(str) {
  debug("sending command " + str);
  webSocket.send(str);
}

function debug(txt) {
  console.log(txt);
}

function appendData(data) {
  var textobtn = data['btn'];
  if (textobtn.indexOf("@") >= 1) {
    textobtn = textobtn.substring(0, textobtn.indexOf("@"));
  }
  docommand(textobtn, data['cmd'], data['data'], data['slot']);
}

function docommand(nro, comando, texto, slot) {
  //console.log("in docommand " + nro + " " + comando + " " + texto + " " + slot);
  if (comando == "status") {
    // status is a reserved word
    comando = "xstatus";
  }

  if (comando != "zbuttons") {
    debug(nro + "," + comando + "=" + texto + " en slot " + slot);
  }

  if (typeof execute[comando] == "function") {
    execute[comando](nro, texto, slot);
  } else {
    //debug("Comando " + comando + " no implementado");
  }
}

function dial(numerodestino) {
  numerodestino = stripNonNumeric(numerodestino);
  if (numerodestino.length > 0) {
    if (myposition > 0) {
      var clave = secret + lastkey;
      var hash = md5(clave);
      var useorigin = myposition;
      var encoded_clid = Base64.encode("");
      //var comando = "<msg data=\"" + useorigin + "|dial|" + prefix + numerodestino + "!" + encoded_clid + "|" + hash + "\" />";
      var comando = "<msg data=\"" + useorigin + "|dial|" + prefix + numerodestino + "|" + hash + "\" />"; // Removed "+ "!" + encoded_clid". What is this 'encoded_clid'. It doesn't seem to work if I set it to an extension number 
      send(comando);
      prevent_popups_from = numerodestino;
    } else {
      debug("unable to dial, no position defined");
    }
  } else {
    debug("no dial as number is zero length");
  }
}

function stripNonNumeric(str) {
  // This function removes non-numeric characters
  str += '';
  var rgx = /^\d$/;
  var out = '';
  for (var i = 0; i < str.length; i++) {
    if (rgx.test(str.charAt(i))) {
      if (!((str.charAt(i) == '.' && out.indexOf('.') != -1) ||
        (str.charAt(i) == '-' && out.length != 0))) {
        out += str.charAt(i);
      }
    }
  }
  return out;
}

function translate(texto) {
  texto = texto.substring(1, texto.length);
  var finaltexto = "";
  var params = texto.split("!");
  var format = params.shift();
  if (params.length == 0) {
    finaltexto = lang[langu][format];
  } else if (params.length == 1) {
    finaltexto = sprintf(lang[langu][format], params[0]);
  } else if (params.length == 2) {
    finaltexto = sprintf(lang[langu][format], params[0], params[1]);
  } else if (params.length == 3) {
    finaltexto = sprintf(lang[langu][format], params[0], params[1], params[2]);
  } else if (params.length == 4) {
    finaltexto = sprintf(lang[langu][format], params[0], params[1], params[2], params[3]);
  }
  return finaltexto;
}


