var availLang = new Object();
availLang['cr'] = 'Hrvatski';
availLang['de'] = 'Deutsch';
availLang['el'] = 'Ελληνικά';
availLang['en'] = 'English';
availLang['es'] = 'Español';
availLang['fr_FR'] = 'Francais';
availLang['it'] = 'Italiano';
availLang['hu'] = 'Magyar';
availLang['pl'] = 'Polski';
availLang['pt_BR'] = 'Português';
availLang['ru'] = 'Русский';
availLang['se'] = 'Svenska';
availLang['zh'] = '简体中文';

function save_options() {
  let reconnect = 0;

  chrome.storage.local.get(['wshost', 'wsport', 'exten', 'context', 'pass']).then((value) => {

    var wshost = document.getElementById("wshost").value;
    var wsport = document.getElementById("wsport").value;
    var exten = document.getElementById("exten").value;
    var pass = document.getElementById("pass").value;
    var context = document.getElementById("context").value;
    var lang = document.getElementById("language").options[document.getElementById("language").selectedIndex].value;
    var durat = document.getElementById("gc-popupDuration").value;
    var poplink = document.getElementById("gc-popupLink").value;
    var popbody = document.getElementById("gc-popupContent").value;
    var prefix = document.getElementById("gc-prefix").value;

    var minlength = document.getElementById("gc-minlength").value;
    var maxlength = document.getElementById("gc-maxlength").value;
    var phandler = document.getElementById("gc-protocolHandler").value;


    // change credentials, close/open websocket
    if (wshost != value.wshost || wsport != value.wsport || exten != value.exten || pass != value.pass || context != value.context) {
      reconnect = 1;
    }


    var elemi = document.getElementById("gc-minlength")
    removeClass(elemi, 'invalid');
    if (minlength < 4 || minlength > 10) {
      elemi.focus();
      addClass(elemi, 'invalid');
      return false;
    }

    elemi = document.getElementById("gc-maxlength")
    removeClass(elemi, 'invalid');
    if (maxlength > 30 || maxlength < 10) {
      elemi.focus();
      addClass(elemi, 'invalid');
      return false;
    }

    var links = 0;
    if (document.getElementById("gc-links").checked) {
      links = 1;
    }

    var searchLinks = 0;
    if (document.getElementById("gc-searchLinks").checked) {
      searchLinks = 1;
    }

    var popup = 0;
    if (document.getElementById("gc-popup").checked) {
      popup = 1;
    }

    var clicktoopen = 0;
    if (document.getElementById("gc-clicktoopen").checked) {
      clicktoopen = 1;
    }

    chrome.storage.local.set({ wshost: wshost });
    chrome.storage.local.set({ wsport: wsport });
    chrome.storage.local.set({ lang: lang });
    chrome.storage.local.set({ exten: exten });
    chrome.storage.local.set({ prefix: prefix });
    chrome.storage.local.set({ minlength: minlength });
    chrome.storage.local.set({ maxlength: maxlength });
    chrome.storage.local.set({ pass: pass });
    chrome.storage.local.set({ context: context });
    chrome.storage.local.set({ links: links });
    chrome.storage.local.set({ searchLinks: searchLinks });
    chrome.storage.local.set({ popup: popup });
    chrome.storage.local.set({ language: lang });
    chrome.storage.local.set({ duration: durat });
    chrome.storage.local.set({ poplink: poplink });
    chrome.storage.local.set({ popbody: popbody });
    chrome.storage.local.set({ clicktoopen: clicktoopen });
    chrome.storage.local.set({ phandler: phandler });

    // Update status to let user know options were saved.
    var status = document.getElementById("status");
    status.innerHTML = "Options Saved.";
    setTimeout(function() { status.innerHTML = ""; }, 1250);

    chrome.runtime.sendMessage({ 'saveoptions': true }, function(response) { console.log(response); });
    if (reconnect == 1) {
      chrome.runtime.sendMessage({ 'reconnect': true }, function(response) { console.log(response); });
    }

  })
}

// Restores select box state to saved value from window.localStorage.
function restore_options() {

  chrome.storage.local.get(['wshost', 'wsport', 'poplink', 'popbody', 'pophandler', 'exten', 'prefix', 'context', 'pass', 'links', 'searchLinks', 'popup', 'minlength', 'maxlength', 'durat', 'lang', 'clicktoopen']).then((value) => {
    //chrome.storage.local.get(['wshost', 'wsport', 'poplink', 'popbody', 'exten', 'prefix', 'context', 'pass', 'popup', 'durat', 'lang', 'clicktoopen']).then((value) => {

    if (value.wshost === undefined) { value.wshost = '192.168.10.1'; }
    if (value.wsport === undefined) { value.wsport = '4445'; }
    if (value.poplink === undefined) { value.poplink = ''; }
    if (value.popbody === undefined) { value.popbody = ''; }
    if (value.pophandler === undefined) { value.pophandler = ''; }
    if (value.exten === undefined) { value.exten = ''; }
    if (value.prefix === undefined) { value.prefix = ''; }
    if (value.context === undefined) { value.context = ''; }
    if (value.pass === undefined) { value.pass = ''; }
    if (value.minlength === undefined) { value.minlength = 8; }
    if (value.maxlength === undefined) { value.maxlength = 20; }
    if (value.durat === undefined) { value.durat = 0; }
    if (value.links === undefined) { value.links = 0; }
    if (value.searchLinks === undefined) { value.searchLinks = 0; }
    if (value.popup === undefined) { value.popup = 0; }
    if (value.lang === undefined) { value.lang = 'en'; }
    if (value.clicktoopen === undefined) { value.clicktoopen = 0; }

    document.getElementById('wshost').value = value.wshost;
    document.getElementById('wsport').value = value.wsport;
    document.getElementById('gc-popupLink').value = value.poplink;
    document.getElementById('gc-popupContent').value = value.popbody;
    document.getElementById('gc-protocolHandler').value = value.pophandler;
    document.getElementById('exten').value = value.exten;
    document.getElementById('gc-prefix').value = value.prefix;
    document.getElementById('context').value = value.context;
    document.getElementById('pass').value = value.pass;
    document.getElementById('gc-minlength').value = value.minlength;
    document.getElementById('gc-maxlength').value = value.maxlength;
    document.getElementById('gc-popupDuration').value = value.durat;

    if (value.links == 1) { document.getElementById("gc-links").checked = true; } else { 
      document.getElementById("gc-links").checked = false; 
      document.getElementById("gc-searchLinks").disabled = true; 
    }
    

    if (value.searchLinks == 1) { 
      document.getElementById("gc-searchLinks").checked = true; 
    } else { 
      document.getElementById("gc-searchLinks").checked = false; 
    }

    if (value.popup == 1) { document.getElementById("gc-popup").checked = true; } else { document.getElementById("gc-popup").checked = false; }
    if (value.clicktoopen == 1) { document.getElementById("gc-clicktoopen").checked = true; } else { document.getElementById("gc-clicktoopen").checked = false; }

    $.each(availLang, function(val, text) {
      $('#language').append(
        $('<option></option>').val(val).html(text)
      );
    });

    $("#language > option").each(function(i, self) {
      if (self.value == value.lang) {
        $("#language").val(self.value);
      }
    });
  });
}

document.addEventListener('DOMContentLoaded', function() {
  restore_options();
  document.getElementById('optionsSave').addEventListener('click', save_options);
  document.getElementById('gc-links').addEventListener('click', () => {
    if (document.getElementById("gc-links").checked){
      document.getElementById("gc-searchLinks").disabled = false; 
    } else { 
      document.getElementById("gc-searchLinks").disabled = true; 
    }
  });
  //  document.getElementById('gc-minlength').addEventListener('blur', verify_field);
  //  document.getElementById('gc-maxlength').addEventListener('blur', verify_field);
});

function verify_field(self) {

  var eleid = self.id;

  if (eleid == "gc-minlength") {
    if (self.value < 6 || self.value > 10) {
      self.focus();
      addClass(self, 'invalid');
      removeClass(self, 'valid');
    } else {
      removeClass(self, 'invalid');
      addClass(self, 'valid');
    }
    return true;
  }

  if (eleid == "gc-maxlength") {
    if (self.value < 10 || self.value > 30) {
      self.focus();
      addClass(self, 'invalid');
      removeClass(self, 'valid');
    } else {
      removeClass(self, 'invalid');
      addClass(self, 'valid');
    }
    return true;
  }

}

function addClass(element, classToAdd) {
  var currentClassValue = element.className;

  if (currentClassValue.indexOf(classToAdd) == -1) {
    if ((currentClassValue == null) || (currentClassValue === "")) {
      element.className = classToAdd;
    } else {
      element.className += " " + classToAdd;
    }
  }
}

function removeClass(element, classToRemove) {
  var currentClassValue = element.className;

  if (currentClassValue == classToRemove) {
    element.className = "";
    return;
  }

  var classValues = currentClassValue.split(" ");
  var filteredList = [];

  for (var i = 0; i < classValues.length; i++) {
    if (classToRemove != classValues[i]) {
      filteredList.push(classValues[i]);
    }
  }

  element.className = filteredList.join(" ");
}
