var searchLinks = false;
var fop2minlength = 8;
var fop2maxlength = 20;
var fop2phandler = '';

// call javascript function on main tab if popup starts with javascript:
chrome.runtime.onMessage.addListener(
  (request, sender, sendResponse) => {
    if (request.message === "popup") {
      var fnstr = "javascript:" + request.call + "('" + JSON.stringify(request.params) + "'); void 0";
      location.href = fnstr;
      sendResponse({ message: "ok" });
    }
  });

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
  if (request.method == "getSelection") {
    sendResponse({ data: window.getSelection().toString() });
  } else {
    //console.warn("call modify page from onmessage addlistener not get selection");
    modifyPage();
  }
});

chrome.runtime.sendMessage({ data: "pageLoaded" }, function(response) {
  //console.warn("call modify page from sendmessage pageLoaded");
  modifyPage();
});

const observer = new MutationObserver((mutations) => {
  mutations.forEach((mutation) => {
    if (mutation.addedNodes.length > 0) {
      mutation.addedNodes.forEach(processNode)
    } else {
      processNode(mutation.target, () => { attachEvents(); })
    }
  })
})

function modifyPage() {
  chrome.storage.local.get(['minlength', 'maxlength', 'phandler', 'links', 'searchLinks'], function (response) {
    if (response['searchLinks'] !== undefined) { searchLinks = response['searchLinks']; }
    if (response['minlength'] !== undefined) { fop2minlength = response['minlength']; }
    if (response['maxlength'] !== undefined) { fop2maxlength = response['maxlength']; }
    if (response['phandler'] !== undefined) { fop2phandler = response['phandler']; }
    if (response['links'] == 1) {
      processNode(document, () => { attachEvents(); });
      observer.observe(document, { childList: true, characterData: true, subtree: true });
    }
  });
}

function processNode(node, callback, totalNodes = { count: 0 }) {
  totalNodes.count++;
  if (node.childNodes.length > 0) {
    Array.from(node.childNodes).forEach(child => processNode(child, callback, totalNodes));
  }
  if (node.nodeType === Node.TEXT_NODE && node.textContent !== null && node.textContent.trim().length > 0) {
    const parent = node.parentElement
    const nodeType = parent ? parent.tagName.toUpperCase() : '';
    if (parent !== null && (nodeType === 'SCRIPT' || nodeType === 'BUTTON' || nodeType === 'STYLE' || parent.classList.contains('fop2-click-to-call'))) {
      // Already converted
      checkCompletion(callback, totalNodes)
      return
    }

    if (searchLinks && nodeType === 'A' ) {
      findPhones(node, true);
    } else {
      findPhones(node, false);
    }
  }
  checkCompletion(callback, totalNodes);
}

function checkCompletion(callback, totalNodes) {
  totalNodes.count--;
  if (totalNodes.count === 0 && callback) {
    callback();
  }
}

/** Remove click-to-call links and messages **/
function clearPage() {
  $('.fop2-message-box').remove();
  $('.fop2-click-to-call').each(function() {
    $(this).replaceWith(this.innerHTML);
  });
}

function findPhones(node, isLink) {

  if (!node || node.nodeValue.length < fop2minlength || node.nodeValue.search(/\d/) == -1) {
    // debug('nodo muy corto -' + node.nodeValue + '- (' + node.nodeValue.length + ')');
    return 0;
  }

  const somedate1 = /[0-9]{1,2}[\/-][0-9]{1,2}[\/-][0-9]{4}\s?/;
  const somedate2 = /[0-9]{4}[\/-][0-9]{1,2}[\/-][0-9]{1,2}\s?/;
  const IPAddress = /\b(?:\d{1,3}\.){3}\d{1,3}\b/;
  const creditCard = /\b\d{4}[-.\s]?\d{4}[-.\s]?\d{4}[-.\s]?\d{4}\b/;
  const sometransaction = /\d{4,}-\d{4,}/; // to handle zip and more
  const phoneRegex = /(\+?\d{1,3}[-.\s]?)?\(?[1-9]\d{1,4}\)?[-.\s]?\d{1,4}[-.\s]?\d{1,9}\b/g; // Added 'g' flag for global search

  var text = node.nodeValue;
  var trimmedText = text.trim();

  // Check if we should ignore this text
  if (trimmedText.includes('#') ||
    trimmedText.match(somedate1) ||
    trimmedText.match(somedate2) ||
    trimmedText.match(IPAddress) ||
    trimmedText.match(creditCard) ||
    trimmedText.match(sometransaction)) {
    return 0;
  }

  // Find all matches, not just the first one
  var matches = [];
  var match;
  while ((match = phoneRegex.exec(text)) !== null) {
    var number = match[0];
    var numbertrim = number.trim();
    
    if (numbertrim.length >= fop2minlength && numbertrim.length <= fop2maxlength) {
      matches.push({
        number: number,
        index: match.index
      });
    }
  }

  if (matches.length === 0) {
    return 0;
  }

  if (isLink) {
    // Get the parent anchor element
    const linkElement = node.parentElement;

    // Check if we've already processed this link
    if (linkElement.hasAttribute('data-fop2-phone-processed')) {
      return 0;
    }
    // Mark as processed to avoid duplicates
    linkElement.setAttribute('data-fop2-phone-processed', 'true');

    // For links, we'll add click-to-call for each number found
    matches.forEach((matchData, index) => {
      const stringNumber = matchData.number.replace(/sip:/, '');
      const callLink = document.createElement('a');
      callLink.href = stringNumber;
      callLink.title = "Click to call " + stringNumber;
      callLink.className = "fop2-click-to-call";
      callLink.setAttribute('rel', stringNumber);
      callLink.innerHTML = '(Click to Call)';

      callLink.style.fontSize = '0.9em';
      callLink.style.marginLeft = '4px';
      callLink.style.textDecoration = 'none';
      callLink.style.cursor = 'pointer';
      callLink.style.opacity = '0.8';
      callLink.style.transition = 'opacity 0.2s';

      // Add hover effect
      callLink.addEventListener('mouseenter', function () {
        this.style.opacity = '1';
      });

      callLink.addEventListener('mouseleave', function () {
        this.style.opacity = '0.8';
      });

      // Insert the new link after the original link (or after the previous call link)
      const targetElement = index === 0 ? linkElement : linkElement.parentNode.children[linkElement.parentNode.children.length - 1];
      targetElement.parentNode.insertBefore(callLink, targetElement.nextSibling);
    });

    return matches.length;

  } else {
    // Process matches in reverse order to avoid index shifting issues
    matches.reverse().forEach(matchData => {
      var stringNumber = matchData.number.replace(/sip:/, '');
      var spanNode = document.createElement('a');
      spanNode.href = stringNumber;
      spanNode.title = "Click to call " + stringNumber;
      spanNode.className = "fop2-click-to-call";
      spanNode.setAttribute('rel', stringNumber);

      // Create and manipulate the range
      var range = document.createRange();
      range.setStart(node, matchData.index);
      range.setEnd(node, matchData.index + matchData.number.length);

      // Extract the content and insert the new element
      var docfrag = range.extractContents();
      spanNode.appendChild(docfrag);

      // Insert the new element in place of the extracted content
      range.insertNode(spanNode);
    });

    return matches.length;
  }
}

function attachEvents() {
  document.querySelectorAll('.fop2-click-to-call').forEach(function(element) {
    // Remove existing event listeners (equivalent to unbind)
    element.removeEventListener('click', clickHandler);
    element.removeEventListener('mouseover', mouseoverHandler);
    element.removeEventListener('mouseout', mouseoutHandler);

    // Add new event listeners
    element.addEventListener('click', clickHandler);
    element.addEventListener('mouseover', mouseoverHandler);
    element.addEventListener('mouseout', mouseoutHandler);
  });
}

function clickHandler(e) {
  e.preventDefault();
  callNumber(e.target.innerHTML, e.target.getAttribute('rel'));
  if (e.stopPropagation) e.stopPropagation();
}

function mouseoverHandler() {
  var offset = this.getBoundingClientRect();
  var width = this.offsetWidth;
  var top = offset.top + window.scrollY - 5;
  top = (top > 0) ? top : 0;
  var left = offset.left + window.scrollX + width;
  left = (left > 0) ? left : 0;

  var icon = document.createElement('div');
  icon.className = 'fop2-click-to-call-icon';
  var iconFile = chrome.runtime.getURL('images/telephone19.png');
  icon.style.backgroundImage = 'url(' + iconFile + ')';
  icon.style.backgroundSize = 'containt';
  icon.style.backgroundRepeat = 'no-repeat';
  icon.style.backgroundPosition = 'center';
  icon.style.top = top + 'px';
  icon.style.left = left + 'px';
  document.body.appendChild(icon);
  setTimeout(() => icon.style.opacity = '1', 0);
  this.dataset.iconId = Date.now();
  icon.dataset.id = this.dataset.iconId;
}

function mouseoutHandler() {
  var iconId = this.dataset.iconId;
  var icon = document.querySelector(`.fop2-click-to-call-icon[data-id="${iconId}"]`);
  if (icon) {
    icon.style.opacity = '0';
    setTimeout(() => icon.remove(), 200);
  }
}

document.querySelectorAll('a[href*="callto"]').forEach(function(link) {
  var regi = new RegExp('' + fop2phandler);
  var newUrl = link.getAttribute('href').replace(/^callto:/, fop2phandler);
  var phoneNumber = newUrl.replace(regi, '');

  link.setAttribute('href', newUrl);
  link.setAttribute('rel', phoneNumber);
  link.classList.add('fop2-click-to-call');
});

function cleanPhoneNo(str) {
  return str.replace(/[^\d]/g, '');
}

function callNumber(phoneNumber, cleanNumber) {
  var msg = 'Calling number ';
  msg += '[phone :  ' + phoneNumber + '] - [cleaned:' + cleanNumber + '] ';
  chrome.runtime.sendMessage({ 'makeCall': true, 'phoneNumber': cleanNumber }, function(response) { });
}

function debug(text) {
  console.log(text);
}
